// ThreadDialog.cpp : implementation file
//

#include "stdafx.h"
#include "WatkiSynchronizacja.h"
#include "WatkiSynchronizacjaDlg.h"
#include "ThreadDialog.h"


// CThreadDialog dialog

IMPLEMENT_DYNAMIC(CThreadDialog, CDialog)

CThreadDialog::CThreadDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CThreadDialog::IDD, pParent)
{
    // Tworzenie obiektu semafora o nazwie Semafor
    // Pozwalamy na maksymalnie 3 jednoczenie utworzone obiekty ThreadDialog
    semaphore = new CSemaphore(3, 3, L"Semafor");
    lock = new CSingleLock(semaphore);
    lock->Lock(); // Blokowanie dostpu przy tworzeniu okna wywietlajcego dane firmy
}

CThreadDialog::~CThreadDialog()
{
}

void CThreadDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT1, Edit1);
    DDX_Control(pDX, IDC_BUTTON1, Button1);
    DDX_Control(pDX, IDC_BUTTON2, Button2);
    DDX_Control(pDX, IDC_EDIT2, Edit2);
}

void CThreadDialog::OnClose()
{
    lock->Unlock(); // Przy zamkniciu okna zwalniamy dostp do semafora    
    // Czy edycja jest aktywna?
    // przy zamkniciu okna naley wwczas zwolni muteks
    if(Button1.EnableWindow(FALSE))
        lockMutex->Unlock();
        
    CDialog::OnClose();
}

BEGIN_MESSAGE_MAP(CThreadDialog, CDialog)
    ON_WM_CLOSE()
    ON_BN_CLICKED(IDC_BUTTON1, &CThreadDialog::OnBnClickedButton1)
    ON_BN_CLICKED(IDC_BUTTON2, &CThreadDialog::OnBnClickedButton2)
END_MESSAGE_MAP()


// CThreadDialog message handlers

void CThreadDialog::OnBnClickedButton1()
{
    // Tworzymy obiekt muteksu o nazwie Muteks
    mutex = new CMutex(FALSE, L"Muteks");
    lockMutex = new CSingleLock(mutex);

    if(lockMutex->Lock(0)) // czy muteks jest w stanie zasygnalizowanym?
    {
        // jeli tak, to
        Edit1.SetReadOnly(FALSE);    
        Edit2.SetReadOnly(FALSE);
        Button1.EnableWindow(FALSE);
        Button2.EnableWindow(TRUE);
    }
    else
        AfxMessageBox(L"Edycja wykonywana jest na innej kocwce");        
}

void CThreadDialog::OnBnClickedButton2()
{
    mutex = new CMutex(FALSE, L"Muteks");
    lockMutex->Unlock(); // muteks przechodzi w stan niezasygnalizowany

    Edit1.SetReadOnly(TRUE);
    Edit2.SetReadOnly(TRUE);
    Button1.EnableWindow(TRUE);
    Button2.EnableWindow(FALSE);    
}
